package com.ewaytek.deepseek.config;


import com.ewaytek.deepseek.common.utils.StringUtils;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyStreamVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.AllArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;

import java.util.Objects;


/**
 * dify sse事件监听器
 * @author yangtq
 * @date 2025/2/25
 */

@Slf4j
@AllArgsConstructor
public class DifyAudioSseEventSourceListener extends EventSourceListener{

    private static final String DONE_SIGNAL = "[DONE]";

    private final ResponseBodyEmitter emitter;

    /**
     * {@inheritDoc}
     */
    @Override
    public void onOpen(EventSource eventSource, Response response) {
        log.info("Dify建立sse连接...");
    }

    /**
     * {@inheritDoc}
     */
    @SneakyThrows
    @Override
    public void onEvent(EventSource eventSource, String id, String type, String data) {
        log.debug("DifyEventSourceListener data : {}",data);
        if (data.equals(DONE_SIGNAL)) {
            // 成功响应
            emitter.complete();
            return;
        }

        ObjectMapper mapper = new ObjectMapper();
        DifyStreamVO completionResponse = mapper.readValue(data, DifyStreamVO.class);

        if(completionResponse == null){
            return;
        }
        String content = completionResponse.getAnswer();

        if(StringUtils.isEmpty(content)){
            return;
        }
        try {
            emitter.send("data: " + data + "\n\n");

//            emitter.send(completionResponse);
        } catch (Exception e) {
            log.error("sse信息推送失败！",e);
            eventSource.cancel();
        }
    }

    @Override
    public void onClosed(EventSource eventSource) {
        log.info("Dify关闭sse连接...");
        emitter.complete();

    }

    @SneakyThrows
    @Override
    public void onFailure(EventSource eventSource, Throwable t, Response response) {
        if (Objects.isNull(response)) {
            return;
        }
        ResponseBody body = response.body();
        if (Objects.nonNull(body)) {
            log.error("Dify  sse连接异常data：{}，异常：{}", body.string(), t);
        } else {
            log.error("Dify  sse连接异常data：{}，异常：{}", response, t);
        }
        eventSource.cancel();
    }
}
