package com.ewaytek.deepseek.doadmin.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
public class DefaultAiMessageDTO extends AiMessageDTO {
    private String id;
    private List<Choice> choices;
    private long created;
    private String model;
    private String system_fingerprint;
    private String object;
    private Usage usage;

    @Override
    public String getMessage(String Message) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();

        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        DefaultAiMessageDTO aiMessageDto = objectMapper.readValue(Message, DefaultAiMessageDTO.class);

        return aiMessageDto.getChoices().get(0).getMessage().getContent();
    }

    @Data
    public static class Choice {
        private String finish_reason;
        private int index;
        private Message message;
        private Logprobs logprobs;
    }

    @Data
    public static class Message {
        private String content;
        private List<ToolCall> tool_calls;
        private String role;
    }

    @Data
    public static class ToolCall {
        private String id;
        private String type;
        private Function function;
    }

    @Data
    public static class Function {
        private String name;
        private String arguments;
    }

    @Data
    public static class Logprobs {
        private List<ContentLogprob> content;
    }

    @Data
    public static class ContentLogprob {
        private String token;
        private double logprob;
        private List<Integer> bytes;
        private List<TopLogprob> top_logprobs;
    }

    @Data
    public static class TopLogprob {
        private String token;
        private double logprob;
        private List<Integer> bytes;
    }

    @Data
    public static class Usage {
        private int completion_tokens;
        private int prompt_tokens;
        private int prompt_cache_hit_tokens;
        private int prompt_cache_miss_tokens;
        private int total_tokens;
    }
}
