package com.ewaytek.deepseek.doadmin.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Slf4j
public class StreamingAiMessageDTO extends AiMessageDTO {
    private String id;
    private List<Choice> choices;
    private Long created;
    private String model;
    private String system_fingerprint;
    private String object;
    private Usage usage;

    @Override
    public String getMessage(String Message) throws JsonProcessingException {
        log.info("StreamingAiMessageDTO"+Message);
        if (Message.startsWith("data:")) {
            Message = Message.substring("data:".length());
        }
        Message = Message.trim();
        if (Message.equals("[DONE]")) return "";

        ObjectMapper objectMapper = new ObjectMapper();

        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        StreamingAiMessageDTO aiMessageDto = objectMapper.readValue(Message, StreamingAiMessageDTO.class);

        return aiMessageDto.getChoices().get(0).getDelta().getContent();
    }

   // {"event": "message", "conversation_id": "eef9803c-ae28-4835-9550-3a0841dbc3de", "message_id": "20ffaba9-6337-4123-a645-b8d92f2e1044", "created_at": 1742193362, "task_id": "5e041c60-27fd-4212-b34c-990eec7a3e98", "id": "20ffaba9-6337-4123-a645-b8d92f2e1044", "answer": "\u53ea\u80fd", "from_variable_selector": null}

    @Data
    public static class Choice {
        private Integer index;
        private Delta delta;
        private String finish_reason;
        private Object logprobs;
    }

    @Data
    public static class Delta {
        private String content;
        private String role;
    }

    @Data
    public static class Usage {
        private Integer prompt_tokens;
        private Integer completion_tokens;
        private Integer total_tokens;
        private Integer prompt_cache_hit_tokens;
        private Integer prompt_cache_miss_tokens;
    }
}
