package com.ewaytek.deepseek.doadmin.vo.dify;

import com.ewaytek.deepseek.doadmin.dto.dify.DifyResponseDTO;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import kotlin.Metadata;
import lombok.Data;

import java.util.List;

/**
 * 流式消息时返回对象
 * @author yangtq
 * @date 2025/2/25
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class DifyStreamVO extends DifyResponseDTO {


    //每一轮Agent迭代都会有一个唯一的id
    private String id;

    //任务 ID，用于请求跟踪和下方的停止响应接口
    @JsonProperty("task_id")
    private String taskId;

    //LLM 返回文本块内容
    private String answer;

    //agent_thought在消息中的位置，如第一轮迭代position为1
    private int position;

    //agent的思考内容
    private String thought;

    //工具调用的返回结果
    private String observation;

    //使用的工具列表，以 ; 分割多个工具
    private String tool;

    //工具的输入，JSON格式的字符串(object)。如：{"dalle3": {"prompt": "a cute cat"}}
    @JsonProperty("tool_input")
    private String toolInput;

    //当前 agent_thought 关联的文件ID
    @JsonProperty("message_files")
    private List<String> messageFiles;

    //event: message_file时，文件类型，目前仅为image
    private String type;

    // (string) 文件归属，user或assistant，该接口返回仅为 assistant
    @JsonProperty("belongs_to")
    private String belongsTo;

    //文件访问地址
    private String url;

    private MetadataVO metadata;

    //HTTP 状态码
    private int status;

    //错误码
    private String code;

    //错误消息
    private String message;

    @JsonProperty("from_variable_selector")
    private String fromVariableSelector;

    private String files;
}
