package com.ewaytek.deepseek.service.dify.workflows.impl;

import com.ewaytek.deepseek.common.bean.base.ApiResponse;
import com.ewaytek.deepseek.common.utils.poi.ExcelUtil;
import com.ewaytek.deepseek.config.DifyConfig;
import com.ewaytek.deepseek.doadmin.dto.dify.DIfyImportVerifyDTO;
import com.ewaytek.deepseek.doadmin.vo.dify.workflows.WorkflowsExecVO;
import com.ewaytek.deepseek.service.dify.impl.DifyApiClient;
import com.ewaytek.deepseek.service.dify.workflows.DifyWorkflowsService;
import com.ewaytek.deepseek.task.DifyThread;
import com.ewaytek.deepseek.task.DifyWorkflowsThread;
import okhttp3.OkHttpClient;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

/**
 * @author yangtq
 * @date 2025/3/6
 */
@Service
public class DifyWorkflowsServiceImpl implements DifyWorkflowsService {



    @Resource
    private DifyConfig difyConfig;

    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private OkHttpClient httpClient;


    @Override
    public ApiResponse importVerify(MultipartFile file) throws IOException, InterruptedException, ExecutionException {
        ExcelUtil<WorkflowsExecVO> util1 = new ExcelUtil<>(WorkflowsExecVO.class);
        ExcelUtil<DIfyImportVerifyDTO> util = new ExcelUtil<>(DIfyImportVerifyDTO.class);

        List<DIfyImportVerifyDTO> dataList = util.importExcel(file.getInputStream());

        if (!CollectionUtils.isEmpty(dataList)) {
            // 提交任务到线程池
            List<CompletableFuture<WorkflowsExecVO>> futures = dataList.stream()
                    .filter(data -> data.getQuestion() != null && !data.getQuestion().isEmpty())
                    .map(data -> CompletableFuture.supplyAsync(() -> {
                        DifyWorkflowsThread thread = new DifyWorkflowsThread(data, difyConfig, httpClient);
                        thread.run(); // 执行任务
                        return thread.getWorkflowsExecVO(); // 返回处理后的 WorkflowsExecVO
                    }, threadPoolTaskExecutor))
                    .collect(Collectors.toList());

            // 等待所有任务完成
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(
                    futures.toArray(new CompletableFuture[0]));

            allFutures.get(); // 阻塞等待所有任务完成

            // 收集所有结果
            List<WorkflowsExecVO> results = futures.stream()
                    .map(CompletableFuture::join)
                    .filter(Objects::nonNull) // 确保结果不为 null
                    .collect(Collectors.toList());

            // 导出结果到 Excel 文件
            return util1.exportExcel(results, "DifyWorkflows");
        }
        return ApiResponse.fail();
    }
}
