package com.ewaytek.deepseek.service.doubao;

import com.alibaba.fastjson2.JSON;
import com.ewaytek.deepseek.config.DifyConfig;
import com.ewaytek.deepseek.config.DoubaoSseEventSourceListener;
import com.ewaytek.deepseek.doadmin.dto.dify.DifyChatBlockIngDTO;
import com.ewaytek.deepseek.doadmin.dto.doubao.*;
import com.ewaytek.deepseek.doadmin.vo.dify.BlockingVO;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyStreamVO;
import com.ewaytek.deepseek.service.dify.impl.DifyApiClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSources;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;

import javax.annotation.Resource;
import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicBoolean;

@Service
@Slf4j
@RequiredArgsConstructor
public class DoubaoServiceImpl implements DoubaoService {

    @Resource
    private DifyConfig difyConfig;

    @Resource
    private OkHttpClient httpClient;
    @Resource
    private DifyApiClient difyApiClient;


    @Override
    public ResponseBodyEmitter sseChatPrompt(DoubaoChatDTO doubaoChatDTO) throws IOException {
        ResponseBodyEmitter sseEmitter = new ResponseBodyEmitter(60000L); // 增加超时时间到60秒
        sseEmitter.onCompletion(() -> {
            log.info("会话[{}]sse结束连接......", doubaoChatDTO.getModel());
        });
        //超时回调
        sseEmitter.onTimeout(() -> {
            log.error("会话[{}]sse连接超时......", doubaoChatDTO.getModel());
        });
        //异常回调
        sseEmitter.onError(
                throwable -> {
                    log.error("会话[{}]sse连接失败......", doubaoChatDTO.getModel());
                }
        );
        String uid = UUID.randomUUID().toString();

        DoubaoSseEventSourceListener doubaoSseEventSourceListener=new DoubaoSseEventSourceListener(sseEmitter,uid);
        difyApiClient.streamChatCompletionDoubao( doubaoChatDTO, doubaoSseEventSourceListener);
        return sseEmitter;
    }
}
