//package com.ewaytek.deepseek.service.doubao;
//
//import cn.hutool.core.lang.UUID;
//import com.alibaba.fastjson2.JSON;
//import com.ewaytek.deepseek.config.DifyConfig;
//import com.ewaytek.deepseek.doadmin.dto.dify.DifyChatBlockIngDTO;
//import com.ewaytek.deepseek.doadmin.dto.doubao.*;
//import com.ewaytek.deepseek.doadmin.vo.dify.DifyStreamVO;
//import com.fasterxml.jackson.databind.ObjectMapper;
//import lombok.RequiredArgsConstructor;
//import lombok.extern.slf4j.Slf4j;
//import okhttp3.*;
//import org.springframework.stereotype.Service;
//import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
//
//import javax.annotation.Resource;
//import java.io.IOException;
//import java.util.ArrayList;
//import java.util.List;
//import java.util.concurrent.atomic.AtomicBoolean;
//
//@Service
//@Slf4j
//@RequiredArgsConstructor
//public class DoubaoServiceImpl2 implements DoubaoService {
//
//    @Resource
//    private DifyConfig difyConfig;
//
//    @Resource
//    private OkHttpClient httpClient;
//
//    @Override
//    public ResponseBodyEmitter sseChatPrompt(DoubaoChatDTO doubaoChatDTO) throws IOException {
//            ResponseBodyEmitter sseEmitter = new ResponseBodyEmitter(0L); // 设置合理的超时时间（30秒）
//        AtomicBoolean isClosed = new AtomicBoolean(false); // 用于标记连接是否已经关闭
//
//        // 设置 SSE 连接的回调
//        sseEmitter.onCompletion(() -> {
//            log.info("会话[{}] SSE 连接已关闭", doubaoChatDTO.getModel());
//            isClosed.set(true);
//        });
//        sseEmitter.onTimeout(() -> {
//            log.error("会话[{}] SSE 连接超时", doubaoChatDTO.getModel());
//            isClosed.set(true);
//            sseEmitter.complete();
//        });
//        sseEmitter.onError(throwable -> {
//            log.error("会话[{}] SSE 连接发生错误", doubaoChatDTO.getModel(), throwable);
//            isClosed.set(true);
//            sseEmitter.completeWithError(throwable);
//        });
//
//        // 启动心跳线程
//        startHeartbeatThread(sseEmitter, isClosed);
//
//        String uid = UUID.randomUUID().toString();
//        DifyChatBlockIngDTO difyChatDTO = new DifyChatBlockIngDTO();
//        difyChatDTO.setQuery(doubaoChatDTO.getModel());
//        difyChatDTO.setUser("ewaytek" + System.currentTimeMillis());
//        difyChatDTO.setResponseMode("streaming");
//
//        ObjectMapper mapper = new ObjectMapper();
//        String requestBody = mapper.writeValueAsString(difyChatDTO);
//        Headers headers = new Headers.Builder()
//                .add("Authorization", "Bearer " + difyConfig.getApiKeyTts())
//                .add("Content-Type", "application/json")
//                .build();
//
//        Request request = new Request.Builder()
//                .url(difyConfig.getApiHost() + "chat-messages")
//                .post(RequestBody.create(MediaType.parse("application/json"), requestBody))
//                .headers(headers)
//                .build();
//
//        // 使用异步调用
//        httpClient.newCall(request).enqueue(new Callback() {
//            @Override
//            public void onFailure(Call call, IOException e) {
//                log.error("调用第三方 API 失败", e);
//                sseEmitter.completeWithError(e);
//            }
//
//            @Override
//            public void onResponse(Call call, Response response) throws IOException {
//                if (!response.isSuccessful()) {
//                    log.error("请求第三方 API 失败，状态码: {}", response.code());
//                    sseEmitter.completeWithError(new IOException("请求第三方 API 失败，状态码: " + response.code()));
//                    return;
//                }
//
//                try (ResponseBody responseBody = response.body()) {
//                    if (responseBody == null) {
//                        log.error("第三方 API 返回空响应体");
//                        sseEmitter.completeWithError(new IOException("第三方 API 返回空响应体"));
//                        return;
//                    }
//
//                    log.info("调用第三方 "+responseBody);
//                    while (!responseBody.source().exhausted()) {
//                        String line = responseBody.source().readUtf8Line();
//                        if (line == null || line.isEmpty()) {
//                           continue;
//                        }
//                        log.info("dify {}:", line);
//                        if (line.startsWith("data:")) {
//                            String eventData = line.substring(5).trim(); // 去掉 "data:" 前缀
//                            DifyStreamVO blockingVO =   JSON.parseObject(eventData, DifyStreamVO.class);
//
//                            if ("message_end".equals(blockingVO.getEvent())) {
//                                sendCompletionMessage(sseEmitter, uid);
//                                break;
//                            }
//
//                            // 解析第三方 SSE 数据并转发给客户端
//                            sendProcessedResponse(sseEmitter, uid, blockingVO);
//                        }
//                    }
//                } catch (IOException e) {
//                    log.error("处理第三方 API 响应时发生错误", e);
//                    sseEmitter.completeWithError(e);
//                } finally {
//                    if (!isClosed.get()) {
//                        sseEmitter.complete();
//                    }
//                }
//            }
//        });
//
//        return sseEmitter;
//    }
//
//    private void startHeartbeatThread(ResponseBodyEmitter sseEmitter, AtomicBoolean isClosed) {
////        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
////        scheduler.scheduleAtFixedRate(() -> {
////            if (!isClosed.get()) {
////                try {
////                    sseEmitter.send("data: " + "{}" + "\n\n");
////                } catch (IOException e) {
////                    log.error("发送心跳消息时发生错误", e);
////                    isClosed.set(true);
////                    sseEmitter.completeWithError(e);
////                }
////            }
////        }, 0, 5, TimeUnit.SECONDS); // 每 20 秒发送一次心跳
//    }
//
//    private void sendProcessedResponse(ResponseBodyEmitter sseEmitter, String uid, DifyStreamVO blockingVO) throws IOException {
//        try {
//
//            Delta delta = new Delta();
//            delta.setRole("assistant");
//            delta.setContent(blockingVO.getAnswer());
//
//            Choices choices = new Choices();
//            choices.setFinish_reason(null);
//            choices.setIndex(0);
//            choices.setDelta(delta);
//
//            List<Choices> list = new ArrayList<>();
//            list.add(choices);
//
//            DoubaoChatResponseDTO responseDTO = new DoubaoChatResponseDTO();
//            responseDTO.setId(uid);
//            responseDTO.setCreated(System.currentTimeMillis());
//            responseDTO.setObject("chat.completion.chunk");
//            responseDTO.setModel("CustomLLM");
//            responseDTO.setChoices(list);
//            log.info("sendProcessedResponse "+JSON.toJSONString(responseDTO));
//
//            sseEmitter.send("data: " + JSON.toJSONString(responseDTO) + "\n\n");
//        }catch (IOException e) {
//            log.error("发送数据时发生错误", e);
//            // 在发生错误时，尝试关闭连接
//            sseEmitter.completeWithError(e);
//        }
//
//    }
//
//    private void sendCompletionMessage(ResponseBodyEmitter sseEmitter, String uid) throws IOException {
//        Choices choices = new Choices();
//        choices.setFinish_reason("stop");
//        choices.setIndex(0);
//
//        Usage usage = new Usage();
//        usage.setPrompt_tokens(1);
//        usage.setCompletion_tokens(2);
//        usage.setTotal_tokens(3);
//
//        List<Choices> list = new ArrayList<>();
//        list.add(choices);
//
//        DoubaoChatResponseDTO responseDTO = new DoubaoChatResponseDTO();
//        responseDTO.setId(uid);
//        responseDTO.setCreated(System.currentTimeMillis());
//        responseDTO.setObject("chat.completion.chunk");
//        responseDTO.setModel("CustomLLM");
//        responseDTO.setChoices(list);
//        responseDTO.setUsage(usage);
//
//        sseEmitter.send("data: " + JSON.toJSONString(responseDTO) + "\n\n");
//        sseEmitter.send("data: [DONE]\n\n");
//    }
//}
