package com.ewaytek.deepseek.config;

import com.alibaba.nls.client.AccessToken;
import com.alibaba.nls.client.protocol.NlsClient;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.io.IOException;

/**
 * @author yangtq
 * @date 2025/3/28
 */
@Data
@Slf4j
@Configuration
@ConfigurationProperties(prefix = "tts")
public class AliTtsConfig {

    private String appKey;
    private String accessKeyId;
    private String accessKeySecret;
    private String voice;

    private int volume;

    private int speech_rate;

    private int pitch_rate;

    private int longText;


    private static NlsClient client;
    private static AccessToken accessToken;

    @PostConstruct
    public void init() {
        log.info("客户端启动-------------------------->");
        synchronized (this) {
            applyAccessToken(accessKeyId, accessKeySecret);
            client = new NlsClient(accessToken.getToken());
            log.info("阿里云 NlsClient 初始化完毕");
        }
    }

    public static void applyAccessToken(String accessKeyId, String accessKeySecret) {
        accessToken = new AccessToken(accessKeyId, accessKeySecret);
        try {
            accessToken.apply();
            log.info("get token: " + accessToken.getToken() + ", expire time: " + accessToken.getExpireTime());
        } catch (IOException e) {
            log.error("https获取accessToken失败！" + e.getMessage());
        }
    }


    public static AccessToken getAccessToken() {
        return accessToken;
    }

    public static NlsClient getNlsClient() {
        return client;
    }

    public String getAppKey() {
        return appKey;
    }

}
