package com.ewaytek.deepseek.controller;

import com.ewaytek.deepseek.common.bean.base.ApiResponse;
import com.ewaytek.deepseek.service.dify.workflows.DifyWorkflowsService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

/**
 * @author yangtq
 * @date 2025/3/6
 */
@RequiredArgsConstructor
@RestController
@Slf4j
@RequestMapping("/dify/workflows")
public class DifyWorkflowsController {


    @Resource
    private DifyWorkflowsService difyWorkflowsService;

    /**
     * 导入
     * @param file
     * @return
     */
    @PostMapping("/importVerify")
    public ApiResponse importVerify(HttpServletRequest request, HttpServletResponse response, @RequestParam(value = "file") MultipartFile file) throws IOException, InterruptedException, ExecutionException {

        return difyWorkflowsService.importVerify(file);

    }
}
