package com.ewaytek.deepseek.doadmin.dto.dify;

import com.ewaytek.deepseek.doadmin.vo.dify.DifyChatVO;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author yangtq
 * @date 2025/2/26
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)

public class DifyChatBlockIngDTO {

    /**
     * 输入提问内容
     */
    private String query;


    /**
     * 回复模式：streaming流式模式,blocking阻塞模式
     */
    @JsonProperty("response_mode")
    private String responseMode;

    /**
     * （选填）会话id，需要基于之前的聊天记录继续对话，必须传之前消息的 conversation_id
     * */
    @JsonProperty("conversation_id")
    private String conversationId;
    /**
     * 用户标识，用于定义终端用户的身份，方便检索、统计。 由开发者定义规则，需保证用户标识在应用内唯一。
     * */
    private String user="";

    /**
     * (选填)允许传入 App 定义的各变量值
     */
    private Map<String,String> inputs=new HashMap<>();

}
