package com.ewaytek.deepseek.common.enums;


/**
 * @author lhx
 * @Description ErrorCode自定义错误码
 * @date: 2023/3/26 11:24
 * @return
 **/
public enum ErrorCode implements IErrorCode {
    SUCCESS(0, "成功"),
    USER_NOT_AUTH(401, "未授权访问,请重新登录"),
    USERTOKEN_EXCEPTION(40101, "获取userExt信息为空！"),
    USERTOKENPRE_EXCEPTION(40102, "userExt解析异常！"),
    USERTOKENPRE_LEVEL_EXCEPTION(40103, "注册用户需满足核验等级为L2及以上，请先完成核验等级升级"),
    USERTOK_EXPIRE_EXCEPTION(40104, "无效token或已过期"),
    USER_DELETE_EXCEPTION(40105, "该账号已被删除，如有疑问，请联系贵公司账号管理员或联系平台客服"),
    USER_CHANGE_AUTH(40106, "该账号权限发生变化，请重新登录，如有疑问，请联系管理员"),
    USER_NOT_AUTH_EXECPTION(40111, "权限不足，请联系管理员"),
    REQ_EXECPTION(40112, "您所访问的页面请求中有违反安全规则元素存在，拒绝访问!"),
    USERAUTH_EXCEPTION(403, "用户[%s]请求服务端口时[%s]权限验证失败！"),
    FILE_D_EXCEPTION(1001, "文件不存在！"),
    INTERNAL_ERR(102, "业务处理异常"),
    JSON_FORMAT_ERR(105, "json数据格式不正确"),
    FAIL(115, "操作失败"),
    SYSTEM_EXCEPTION(116, "系统异常"),
    PARAMS_INVALID(106, "参数不合法"),
    USER_ACCOUT_NOTEXSIT(6101, "账号不存在"),
    USER_ACCOUT_DISABLE(6102, "该账号已被禁用"),

    RESOURCE_NOT_FOUND(7100, "资源不存在"),
    PATH_NOT_FOUND(7101, "访问路径不存在: %s"),

    // 请求应从manualpre服务端进来，禁止直接访问当前服务
    ACCESS_FORBIDDEN(8100, "access forbidden"),
    ;

    private final Integer errcode;
    private final String errmsg;

    ErrorCode(int errcode, String errmsg) {
        this.errcode = errcode;
        this.errmsg = errmsg;
    }

    @Override
    public Integer getErrcode() {
        return errcode;
    }

    @Override
    public String getErrmsg() {
        return errmsg;
    }
}
