package com.ewaytek.deepseek.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Map;

@Data
@Configuration
@ConfigurationProperties(prefix = "deepseek")
public class DeepSeekConfig {
    private String url;

    private String apiKey;

    private String model;

    private Double frequencyPenalty;

    private Integer maxTokens;

    private Double presencePenalty;

    private ResponseFormat responseFormat;

    private List<String> stop;

    private Boolean stream;

    private StreamOptions streamOptions;

    private Double temperature;

    private Double topP;

    private List<Tool> tools;

    private String toolChoice;

    private Boolean logprobs;

    private Integer topLogprobs;

    @Data
    public static class ResponseFormat {
        private String type;
    }
    @Data
    public static class StreamOptions {
        private Boolean includeUsage;
    }
    @Data
    public static class Tool {
        private String type;

        private Function function;
    }
    @Data
    public static class Function {
        private String name;

        private String description;

        private Map<String, Object> parameters;
    }
}
