package com.ewaytek.deepseek.config;

import com.ewaytek.deepseek.service.dify.impl.DifyApiClient;
import com.ewaytek.deepseek.service.dify.impl.KeyRandomStrategy;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;

import java.util.concurrent.TimeUnit;


/**
 * @author yangtq
 * @date 2025/2/25
 */
@Data
@Slf4j
@Configuration
@ConfigurationProperties(prefix = "dify")
public class DifyConfig {

    @Value("${dify.api-key}")
    private String apiKey;

    @Value("${dify.api-host}")
    private String apiHost;

    @Value("${dify.conversation_url}")
    private String conversationUrl;
    @Value("${dify.api_key_tts}")
    private String apiKeyTts;

    @Bean(name = "difyApiClient")
    public DifyApiClient difyApiClient() {
        OkHttpClient okHttpClient;
        okHttpClient = new OkHttpClient
                .Builder()
                .connectTimeout(30, TimeUnit.SECONDS)
                .writeTimeout(600, TimeUnit.SECONDS)
                .readTimeout(600, TimeUnit.SECONDS)
                .build();

        return DifyApiClient
                .builder()
                .apiHost(apiHost)
                .apiKey(apiKey)
                //自定义key使用策略 默认随机策略
                .keyStrategy(new KeyRandomStrategy())
                .okHttpClient(okHttpClient)
                .build();
    }

}
