package com.ewaytek.deepseek.config;

import com.alibaba.fastjson2.JSON;
import com.ewaytek.deepseek.doadmin.dto.doubao.Choices;
import com.ewaytek.deepseek.doadmin.dto.doubao.Delta;
import com.ewaytek.deepseek.doadmin.dto.doubao.DoubaoChatResponseDTO;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyStreamVO;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Slf4j
public class DoubaoSseEventSourceListener extends EventSourceListener {

    private static final String DONE_SIGNAL = "[DONE]";
    private final ResponseBodyEmitter emitter;
    private final String Uid;


    public DoubaoSseEventSourceListener(ResponseBodyEmitter sseEmitter, String uid) {
        this.emitter = sseEmitter;
        this.Uid=uid;
    }


    @Override
    public void onOpen(EventSource eventSource, Response response) {
        log.info("Dify 建立 SSE 连接...");

    }

    @Override
    public void onEvent(EventSource eventSource, String id, String type, String data) {
        log.info("DifyEventSourceListener 收到数据: {}", data);
        DifyStreamVO blockingVO =   JSON.parseObject(data, DifyStreamVO.class);

        if ("message_end".equals(blockingVO.getEvent())) {
            log.info("Dify 流式响应完成");
            try {
                sendProcessedResponse();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            emitter.complete();
            return;
        }

        try {
            // 直接将数据发送给客户端
//            emitter.send("data: " + data + "\n\n");
            sendProcessedResponse(blockingVO);
        } catch (Exception e) {
            log.error("SSE 信息推送失败！", e);
            eventSource.cancel();
        }
    }

    private void sendProcessedResponse(DifyStreamVO blockingVO) throws IOException {
        try {

            Delta delta = new Delta();
            delta.setRole("assistant");
            delta.setContent(blockingVO.getAnswer());

            Choices choices = new Choices();
            choices.setFinish_reason(null);
            choices.setIndex(0);
            choices.setDelta(delta);

            List<Choices> list = new ArrayList<>();
            list.add(choices);

            DoubaoChatResponseDTO responseDTO = new DoubaoChatResponseDTO();
            responseDTO.setId(Uid);
            responseDTO.setCreated(System.currentTimeMillis());
            responseDTO.setObject("chat.completion.chunk");
            responseDTO.setModel("CustomLLM");
            responseDTO.setChoices(list);
            log.info("sendProcessedResponse "+JSON.toJSONString(responseDTO));

            emitter.send("data: " + JSON.toJSONString(responseDTO) + "\n\n");
        }catch (IOException e) {
            log.error("发送数据时发生错误", e);
            // 在发生错误时，尝试关闭连接
            emitter.completeWithError(e);
        }

    }

        private void sendProcessedResponse() throws IOException {
        try {

            Delta delta = new Delta();
            delta.setRole("assistant");
            delta.setContent(null);

            Choices choices = new Choices();
            choices.setFinish_reason(null);
            choices.setIndex(0);
            choices.setDelta(delta);

            List<Choices> list = new ArrayList<>();
            list.add(choices);

            DoubaoChatResponseDTO responseDTO = new DoubaoChatResponseDTO();
            responseDTO.setId(Uid);
            responseDTO.setCreated(System.currentTimeMillis());
            responseDTO.setObject("chat.completion.chunk");
            responseDTO.setModel("CustomLLM");
            responseDTO.setChoices(list);
            log.info("sendProcessedResponse "+JSON.toJSONString(responseDTO));

            emitter.send("data: " + JSON.toJSONString(responseDTO) + "\n\n");
        }catch (IOException e) {
            log.error("发送数据时发生错误", e);
            // 在发生错误时，尝试关闭连接
            emitter.completeWithError(e);
        }

    }

    @Override
    public void onClosed(EventSource eventSource) {
        log.info("Dify 关闭 SSE 连接...");
        emitter.complete();
    }

    @Override
    public void onFailure(EventSource eventSource, Throwable t, Response response) {
        log.error("Dify SSE 连接异常: {}", t.getMessage());
        if (response != null) {
            try {
                log.error("异常响应数据: {}", response.body().string());
            } catch (IOException e) {
                log.error("读取异常响应数据失败", e);
            }
        }
        eventSource.cancel();
        emitter.completeWithError(t); // 将错误传递给客户端
    }

}
