package com.ewaytek.deepseek.controller;

import com.ewaytek.deepseek.common.bean.base.ApiResponse;
import com.ewaytek.deepseek.common.utils.StringUtils;
import com.ewaytek.deepseek.doadmin.dto.MessageDTO;
import com.ewaytek.deepseek.doadmin.dto.dify.DifyChatDTO;
import com.ewaytek.deepseek.doadmin.vo.MessageVO;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyChatVO;
import com.ewaytek.deepseek.service.AiChatService;
import com.ewaytek.deepseek.service.dify.DifyChatService;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;
import java.util.Map;

@RestController
public class AiChatController {
    @Autowired
    private AiChatService aiChatService;


    //流式模式
    private final static String STREAMING_MODE = "streaming";
    //阻塞模式
    private final static String BLOCKING_MODE = "blocking";



    @PostMapping(value = "/system/chat", produces = "application/stream+json")
    public Flux<String> systemChat(@RequestBody List<Map<String, String>> messages) {
        Flux<String> responseFlux = aiChatService.chat(messages);

        return Flux.create(sink -> {
            responseFlux.subscribeOn(Schedulers.boundedElastic())
                    .subscribe(
                            sink::next, // 返回流式字符串
                            sink::error, // 返回错误，请在调用端完成错误处理
                            sink::complete // 返回完成事件
                    );
        });
    }

    @PostMapping(value = "/chat")
    public ApiResponse<MessageVO> chat(@RequestBody List<MessageDTO> messages) {
        return aiChatService.msgChat(messages);
    }







    private DifyChatVO difyPojo(DifyChatDTO dto) {
        DifyChatVO difyChatVO = new DifyChatVO();
        difyChatVO.setResponseMode(STREAMING_MODE);
        difyChatVO.setQuery(dto.getQuery());
        difyChatVO.setUser(dto.getUserId().toString());
        if (StringUtils.isNotEmpty(dto.getConversationId())) {
            difyChatVO.setConversationId(dto.getConversationId());
        }
        return difyChatVO;
    }

}
