package com.ewaytek.deepseek.controller;


import com.ewaytek.deepseek.common.bean.base.ApiResponse;
import com.ewaytek.deepseek.common.utils.StringUtils;
import com.ewaytek.deepseek.common.utils.poi.ExcelUtil;
import com.ewaytek.deepseek.doadmin.dto.dify.DIfyImportVerifyDTO;
import com.ewaytek.deepseek.doadmin.dto.dify.DifyChatBlockIngDTO;
import com.ewaytek.deepseek.doadmin.dto.dify.DifyChatDTO;
import com.ewaytek.deepseek.doadmin.dto.doubao.DoubaoChatDTO;
import com.ewaytek.deepseek.doadmin.vo.dify.ConversationsVO;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyChatVO;
import com.ewaytek.deepseek.service.dify.DifyChatService;

import com.ewaytek.deepseek.service.doubao.DoubaoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.repository.query.Param;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import reactor.core.publisher.Flux;


import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;


/**
 * @author yangtq
 * @date 2025/2/25
 */
@RequiredArgsConstructor
@RestController
@Slf4j
@RequestMapping("/dify")
public class DifyController {

    //流式模式
    private final static String STREAMING_MODE = "streaming";
    //阻塞模式
    private final static String BLOCKING_MODE = "blocking";

    @Resource
    private DifyChatService difyChatService;

    @Resource
    private DoubaoService doubaoService;








    /**
     * diff 流
     *
     * @param ResponseBodyEmitter
     * @return
     */
    @PostMapping(value = "/stream/chat")
    @ResponseBody
    public ResponseBodyEmitter systemChat(@RequestBody @Valid DifyChatDTO dto, HttpServletResponse response) {
        response.setContentType(MediaType.TEXT_EVENT_STREAM_VALUE); // 设置响应类型为 Server-Sent Events
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        DifyChatVO difyChatVO = new DifyChatVO();
        difyChatVO.setResponseMode(STREAMING_MODE);
        difyChatVO.setQuery(dto.getQuery());
        difyChatVO.setUser(dto.getUserId().toString());
        if (StringUtils.isNotEmpty(dto.getConversationId())) {
            difyChatVO.setConversationId(dto.getConversationId());
        }
        return difyChatService.sseChatPrompt(difyChatVO);

    }


    /**
     * 获取会话id
     *
     * @param dto
     * @param response
     * @return
     */
    @GetMapping(value = "/id")
    @ResponseBody
    public ApiResponse<List<ConversationsVO.ConversationInfoVO>> conversations(@RequestParam(required = false) Integer limit, @RequestParam(required = false) Boolean pinned) {
        ApiResponse<List<ConversationsVO.ConversationInfoVO>> listApiResponse = difyChatService.conversations(limit, pinned);
        return listApiResponse;
    }

    /**
     * 导入
     * @param file
     * @return
     */
    @PostMapping("/importVerify2")
    public void importVerify2(HttpServletRequest request, HttpServletResponse response, @RequestParam(value = "file") MultipartFile file) throws IOException, InterruptedException {
        difyChatService.importVerify2(request,response,file);
    }

    @PostMapping("/processBatch")
    public ApiResponse<DIfyImportVerifyDTO> processBatch(@RequestBody DIfyImportVerifyDTO dto) throws JsonProcessingException {
        DIfyImportVerifyDTO dIfyImportVerifyDTO = difyChatService.processBatch(dto);
        return ApiResponse.success(dIfyImportVerifyDTO);
    }



    /**
     * 导入
     * @param file
     * @return
     */
    @PostMapping("/importVerify")
    public ApiResponse importVerify(HttpServletRequest request, HttpServletResponse response, @RequestParam(value = "file") MultipartFile file) throws IOException, InterruptedException, ExecutionException {

       return difyChatService.importVerify( file);
    }


    /**
     * 导入
     * @param file
     * @return
     */
    @PostMapping(value = "/doubao")
    @ResponseBody
    public ResponseBodyEmitter systemCha1t(@RequestBody DoubaoChatDTO doubaoChatDTO, HttpServletResponse response, HttpServletRequest request) throws IOException {

        log.info("参数名getModel：{}，参数值：{}", doubaoChatDTO.getModel(), doubaoChatDTO.getModel());
        log.info("参数名getModel：{}，参数值：{}", doubaoChatDTO.getTemperature(), doubaoChatDTO.getTemperature());
        log.info("参数名getModel：{}，参数值：{}", doubaoChatDTO.getMessages(), doubaoChatDTO.getMessages());
        log.info("参数名getModel：{}，参数值：{}", doubaoChatDTO.getTop_p(), doubaoChatDTO.getTop_p());


        response.setContentType(MediaType.TEXT_EVENT_STREAM_VALUE); // 设置响应类型为 Server-Sent Events
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");

        return   doubaoService.sseChatPrompt(doubaoChatDTO);
    }



}
