package com.ewaytek.deepseek.doadmin.dto.dify.demo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
/**
 * @author yangtq
 * @date 2025/3/6
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class DIfyWorkflowsResultDTO {
    @JsonProperty("event")
    private String event;

    @JsonProperty("workflow_run_id")
    private String workflowRunId;

    @JsonProperty("task_id")
    private String taskId;

    @JsonProperty("data")
    private Data data;


    @lombok.Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Data {
        @JsonProperty("id")
        private String id;

        @JsonProperty("workflow_id")
        private String workflowId;

        @JsonProperty("sequence_number")
        private int sequenceNumber;

        @JsonProperty("status")
        private String status;

        @JsonProperty("outputs")
        private Outputs outputs;

        @JsonProperty("error")
        private Object error; // 根据实际需求调整类型

        @JsonProperty("elapsed_time")
        private double elapsedTime;

        @JsonProperty("total_tokens")
        private int totalTokens;

        @JsonProperty("total_steps")
        private int totalSteps;

        @JsonProperty("created_by")
        private CreatedBy createdBy;

        @JsonProperty("created_at")
        private long createdAt;

        @JsonProperty("finished_at")
        private long finishedAt;

        @JsonProperty("exceptions_count")
        private int exceptionsCount;

        @JsonProperty("files")
        private List<Object> files; // 根据实际需求调整类型
    }

    @lombok.Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Outputs {
        @JsonProperty("result")
        private List<ResultItem> result;
    }

    @lombok.Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ResultItem {
        @JsonProperty("metadata")
        private Metadata metadata;

        @JsonProperty("title")
        private String title;

        @JsonProperty("content")
        private String content;
    }

    @lombok.Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Metadata {
        @JsonProperty("_source")
        private String source;

        @JsonProperty("dataset_id")
        private String datasetId;

        @JsonProperty("dataset_name")
        private String datasetName;

        @JsonProperty("document_id")
        private String documentId;

        @JsonProperty("document_name")
        private String documentName;

        @JsonProperty("document_data_source_type")
        private String documentDataSourceType;

        @JsonProperty("segment_id")
        private String segmentId;

        @JsonProperty("retriever_from")
        private String retrieverFrom;

        @JsonProperty("score")
        private double score;

        @JsonProperty("segment_hit_count")
        private int segmentHitCount;

        @JsonProperty("segment_word_count")
        private int segmentWordCount;

        @JsonProperty("segment_position")
        private int segmentPosition;

        @JsonProperty("segment_index_node_hash")
        private String segmentIndexNodeHash;

        @JsonProperty("position")
        private int position;
    }

    @lombok.Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class CreatedBy {
        @JsonProperty("id")
        private String id;

        @JsonProperty("user")
        private String user;
    }
}
