package com.ewaytek.deepseek.doadmin.vo.dify;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * dify聊天请求体
 * @author yangtq
 * @date 2025/2/25
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class DifyChatVO {

    /**
     * 输入提问内容
     */
    private String query;

    /**
     * (选填)允许传入 App 定义的各变量值
     */
    private Map<String,String> inputs;

    /**
     * 回复模式：streaming流式模式,blocking阻塞模式
     */
    @JsonProperty("response_mode")
    private String responseMode;

    /**
     * （选填）会话id，需要基于之前的聊天记录继续对话，必须传之前消息的 conversation_id
     * */
    @JsonProperty("conversation_id")
    private String conversationId;
    /**
     * 用户标识，用于定义终端用户的身份，方便检索、统计。 由开发者定义规则，需保证用户标识在应用内唯一。
     * */
    private String user="";

    /**
     * （选填）自动生成标题，默认 false。 可通过调用会话重命名接口并设置 auto_generate 为 true 实现异步生成标题
     * */
    @JsonProperty("autoGenerate_name")
    private boolean autoGenerateName=false;

    private List<UploadFile> files;
    @Data
    public class UploadFile{
        /**
         * 支持类型：图片 image（目前仅支持图片格式）
         * */
        private String type="image";
        /**
         * remote_url: 图片地址
         * local_file: 上传文件
         * */
        @JsonProperty("transfer_method")
        private String transferMethod;

        /**
         *
         * */
        private String url;
        /**
         * 上传文件 ID。（仅当传递方式为 local_file 时）
         * */
        @JsonProperty("upload_file_id")
        private String uploadFileId;
    }

}
