package com.ewaytek.deepseek.service.dify;

import com.ewaytek.deepseek.common.bean.base.ApiResponse;
import com.ewaytek.deepseek.doadmin.dto.dify.DIfyImportVerifyDTO;
import com.ewaytek.deepseek.doadmin.dto.dify.DifyChatBlockIngDTO;
import com.ewaytek.deepseek.doadmin.dto.dify.DifyChatDTO;
import com.ewaytek.deepseek.doadmin.vo.dify.ConversationsVO;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyChatVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import reactor.core.publisher.Flux;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;

/**
 * @author yangtq
 * @date 2025/2/25
 */
public interface DifyChatService {


    /**
     * AI陪聊
     * @param difyChatVO
     * @return
     */
    ResponseBodyEmitter sseChatPrompt(DifyChatVO difyChatVO);

    ApiResponse<List<ConversationsVO.ConversationInfoVO>> conversations(Integer limit, Boolean pinned);

    void importVerify2(HttpServletRequest request, HttpServletResponse response, MultipartFile file) throws IOException, InterruptedException;

    DIfyImportVerifyDTO processBatch(DIfyImportVerifyDTO dto) throws JsonProcessingException;

    ApiResponse importVerify(MultipartFile file) throws IOException, InterruptedException, ExecutionException;


    ApiResponse importVerify3(MultipartFile file) throws IOException, InterruptedException, ExecutionException;

}
