package com.ewaytek.deepseek.service.dify.impl;


import com.alibaba.fastjson2.JSON;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizerListener;
import com.ewaytek.deepseek.common.config.DeepseekConfig;
import com.ewaytek.deepseek.common.utils.StringUtils;
import com.ewaytek.deepseek.config.DifyConfig;
import com.ewaytek.deepseek.doadmin.dto.dify.DifyChatBlockIngDTO;
import com.ewaytek.deepseek.doadmin.vo.DifyAudiVO;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyBlockingVO;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyStreamVO;
import com.ewaytek.deepseek.doadmin.vo.dify.MetadataVO;
import com.ewaytek.deepseek.service.dify.DifyAudioChatService;
import com.ewaytek.deepseek.service.dify.tts.SpeechRecognizerService;
import com.ewaytek.deepseek.service.dify.tts.SpeechSynthesizer;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;

import java.io.*;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author yangtq
 * @date 2025/3/28
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class DifyAudioChatServiceImpl implements DifyAudioChatService {


    @Autowired
    private DifyConfig difyConfig;

    @Autowired
    private OkHttpClient httpClient;

    @Autowired
    private SpeechSynthesizer synthesizer;

    @Autowired
    private SpeechRecognizerService speechRecognizerService;


    private DifyChatBlockIngDTO getBifyEntity(InputStream audioStream, String context) throws Exception {
        DifyChatBlockIngDTO difyChatBlockIngDTO = new DifyChatBlockIngDTO();
        difyChatBlockIngDTO.setUser("ewaytek" + System.currentTimeMillis());
        difyChatBlockIngDTO.setResponseMode("streaming");
        if (context != null && !context.isEmpty()) {
            difyChatBlockIngDTO.setQuery(context);
        } else {
            difyChatBlockIngDTO.setQuery(audioDispose(audioStream));
        }
        return difyChatBlockIngDTO;
    }


    @Override
    public void systemChatAudio(InputStream audioStream, String text, OutputStream emitter) throws Exception {
//        saveAudioFile(audioStream, "uploaded_audio.wav");
        DifyChatBlockIngDTO difyChatBlockIngDTO =getBifyEntity(audioStream,text);

        ObjectMapper mapper = new ObjectMapper();
        String requestBody = mapper.writeValueAsString(difyChatBlockIngDTO);
        Headers headers = new Headers.Builder()
                .add("Authorization", "Bearer " + difyConfig.getApiKeyTts())
                .add("Content-Type", "application/json")
                .build();

        Request request = new Request.Builder()
                .url(difyConfig.getApiHost() + "chat-messages")
                .post(RequestBody.create(MediaType.parse("application/json"), requestBody))
                .headers(headers)
                .build();

        try (Response response = httpClient.newCall(request).execute()) {
            if (!response.isSuccessful()) {
                throw new RuntimeException("请求失败：HTTP " + response.code() + " " + response.message());
            }

            String responseBody = response.body().string();
            systemDispose(responseBody,emitter);
        } catch (Exception e) {
            throw new RuntimeException("请求处理失败", e);
        }
    }

    @Override
    public void systemChatAudioFlie(InputStream audioStream, String context, ResponseBodyEmitter emitter) throws Exception {
        DifyChatBlockIngDTO difyChatBlockIngDTO =getBifyEntity(audioStream,context);

        ObjectMapper mapper = new ObjectMapper();
        String requestBody = mapper.writeValueAsString(difyChatBlockIngDTO);
        Headers headers = new Headers.Builder()
                .add("Authorization", "Bearer " + difyConfig.getApiKeyTts())
                .add("Content-Type", "application/json")
                .build();

        Request request = new Request.Builder()
                .url(difyConfig.getApiHost() + "chat-messages")
                .post(RequestBody.create(MediaType.parse("application/json"), requestBody))
                .headers(headers)
                .build();

        try (Response response = httpClient.newCall(request).execute()) {
            if (!response.isSuccessful()) {
                throw new RuntimeException("请求失败：HTTP " + response.code() + " " + response.message());
            }
            // 处理流式响应
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                StringBuilder responseBuilder = new StringBuilder();

                while (!responseBody.source().exhausted()) {
                    String line = responseBody.source().readUtf8Line();
                    if(line==null||line.isEmpty()){
                        continue;
                    }

                    if(!line.startsWith("data:")){
                        continue;
                    }

                    String eventData = line.substring(5).trim(); // 去掉 "data:" 前缀
                    DifyStreamVO blockingVO =   JSON.parseObject(eventData, DifyStreamVO.class);
                    if(StringUtils.isEmpty(blockingVO.getAnswer())){
                        continue;
                    }
                    emitter.send("data: " + blockingVO.getAnswer()+ "\n\n");

//                    responseBuilder.append(blockingVO.getAnswer());
//                    Pattern pattern = Pattern.compile("[：；。，！]");
//                    Matcher matcher = pattern.matcher(responseBuilder.toString());
//                    if (matcher.find()) {
//                       Field boolField = null;
//                       Boolean sessce = false;
//                       SpeechSynthesizerListener speechSynthesizerListener = synthesizer.process1(responseBuilder.toString());
//                       while (!sessce) {
//                           Thread.sleep(100);
//                           boolField = speechSynthesizerListener.getClass().getDeclaredField("sessce");
//                           boolField.setAccessible(true);
//                           sessce = (Boolean) boolField.get(speechSynthesizerListener);
//                       }
//                       byte[] bytes = getBytes(speechSynthesizerListener);
//                       String name=System.currentTimeMillis()+".wav";
//                       String path=DeepseekConfig.getDownloadPath()+name;
//                       saveAudioToFile(bytes, path);
//                        DifyAudiVO difyAudiVO=new DifyAudiVO();
//                        difyAudiVO.setName(name);
//                        difyAudiVO.setContext(responseBuilder.toString());
//                       emitter.send("data: " + JSON.toJSONString(difyAudiVO) + "\n\n");
//                       responseBuilder.setLength(0);
//                   }
                }
            }


        } catch (Exception e) {
            throw new RuntimeException("请求处理失败", e);
        }


    }


    private void systemDispose(String responseBody,OutputStream emitter) throws IOException, InterruptedException, NoSuchFieldException, IllegalAccessException {
        ObjectMapper mapper = new ObjectMapper();
        DifyBlockingVO blockingVO = mapper.readValue(responseBody, DifyBlockingVO.class);
        List<String> paragraphs = splitTextToParagraphs(blockingVO.getAnswer());
        synthesizeText(paragraphs,emitter);
    }

    private void synthesizeText(List<String> paragraphs,OutputStream outputStream) throws InterruptedException, NoSuchFieldException, IllegalAccessException, IOException {

        for (String paragraph : paragraphs) {
            Field boolField = null;
            Boolean sessce = false;
            SpeechSynthesizerListener speechSynthesizerListener = synthesizer.process1(paragraph);
            while (!sessce) {
                Thread.sleep(100);
                boolField = speechSynthesizerListener.getClass().getDeclaredField("sessce");
                boolField.setAccessible(true);
                sessce = (Boolean) boolField.get(speechSynthesizerListener);
            }
            byte[] bytes = getBytes(speechSynthesizerListener);
//            saveAudioToFile(bytes, "/Users/yang/Downloads/output.wav");
            outputStream.write(bytes);
            outputStream.flush();
        }
        outputStream.close();

    }
    private void saveAudioToFile(byte[] bytes, String fileName) throws IOException {
        File file = new File(fileName);
        try (FileOutputStream fos = new FileOutputStream(file)) {
            fos.write(bytes);
            fos.flush();
        }
    }

    private static byte[] getBytes(SpeechSynthesizerListener speechSynthesizerListener) {
        Field bytesArrayField = null;
        try {
            bytesArrayField = speechSynthesizerListener.getClass().getDeclaredField("bytes");
            bytesArrayField.setAccessible(true);
            byte[] bytes = (byte[]) bytesArrayField.get(speechSynthesizerListener);
            return bytes;
        } catch (NoSuchFieldException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }

    }


    private String audioDispose(InputStream input) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024 * 4];
        int n;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
        }
        return speechRecognizerService.process(output.toByteArray());


    }

    private static List<String> splitTextToParagraphs(String text) {
        String[] splitResult = text.split("([,.?!])");
        List<String> paragraphs = new ArrayList<>();

        for (int i = 0; i < splitResult.length; i++) {
            String content = splitResult[i].trim();
            if (!content.isEmpty()) {
                if (i + 1 < splitResult.length && splitResult[i + 1].matches("[,.?!]")) {
                    paragraphs.add(content + splitResult[i + 1]);
                    i++;
                } else {
                    paragraphs.add(content);
                }
            }
        }

        return paragraphs;
    }

}
