package com.ewaytek.deepseek.service.dify.tts;

import com.alibaba.nls.client.protocol.OutputFormatEnum;
import com.alibaba.nls.client.protocol.SampleRateEnum;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizerListener;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizerResponse;
import com.ewaytek.deepseek.config.AliTtsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author yangtq
 * @date 2025/3/28
 */
public class SpeechSynthesizerDemo {
    private static final Logger logger = LoggerFactory.getLogger(SpeechSynthesizerDemo.class);

    AliTtsConfig aliTtsConfig;

    public SpeechSynthesizerDemo(AliTtsConfig aliTtsConfig) {
        this.aliTtsConfig = aliTtsConfig;
    }

    private static SpeechSynthesizerListener getSynthesizerListener(Date startTime, OutputStream outputStream) {
        return new SpeechSynthesizerListener() {
            private boolean firstRecvBinary = true;
            private List<byte[]> bytesList = new ArrayList<>();
            private byte[] bytes = null;
            private Boolean sessce=false;
            @Override
            public void onComplete(SpeechSynthesizerResponse response) {
                bytes = this.byteMerger(bytesList);
                sessce=true;
                logger.info("name: " + response.getName() + ", status: " + response.getStatus() + ", task_id: " + response.getTaskId());

            }

            @Override
            public void onMessage(ByteBuffer message) {
                if (firstRecvBinary) {
                    firstRecvBinary = false;
                }
                byte[] bytesArray = new byte[message.remaining()];
                message.get(bytesArray, 0, bytesArray.length);
                bytesList.add(bytesArray);
            }

            @Override
            public void onFail(SpeechSynthesizerResponse response) {
                logger.info("task_id: " + response.getTaskId() + ", status: " + response.getStatus() + ", status_text: " + response.getStatusText());
            }

            @Override
            public void onMetaInfo(SpeechSynthesizerResponse response) {
                logger.info("MetaInfo event:{}", response.getTaskId());
            }

            private byte[] byteMerger(List<byte[]> byteList) {
                int lengthByte = 0;
                for (int i = 0; i < byteList.size(); i++) {
                    lengthByte += byteList.get(i).length;
                }
                byte[] allByte = new byte[lengthByte];
                int countLength = 0;
                for (int i = 0; i < byteList.size(); i++) {
                    byte[] b = byteList.get(i);
                    System.arraycopy(b, 0, allByte, countLength, b.length);
                    countLength += b.length;
                }
                return allByte;
            }
        };
    }

    public void process(String word, OutputStream outputStream, Boolean sessce) {
        word = word.replaceAll("<.*?>", "");
        logger.info("word:" + word);
        com.alibaba.nls.client.protocol.tts.SpeechSynthesizer synthesizer = null;
        try {
            SpeechSynthesizerListener speechSynthesizerListener = getSynthesizerListener(new Date(), outputStream);
            synthesizer = new com.alibaba.nls.client.protocol.tts.SpeechSynthesizer(AliTtsConfig.getNlsClient(), speechSynthesizerListener);
            synthesizer.setAppKey(aliTtsConfig.getAppKey());
            synthesizer.setFormat(OutputFormatEnum.WAV);
            synthesizer.setSampleRate(SampleRateEnum.SAMPLE_RATE_8K);
            synthesizer.setVoice(aliTtsConfig.getVoice());
            synthesizer.setVolume(aliTtsConfig.getVolume());
            synthesizer.setPitchRate(aliTtsConfig.getPitch_rate());
            synthesizer.setSpeechRate(aliTtsConfig.getPitch_rate());
            synthesizer.setText(word);
            synthesizer.addCustomedParam("enable_subtitle", true);

            long start = System.currentTimeMillis();
            synthesizer.start();
            logger.info("tts start latency " + word + " " + (System.currentTimeMillis() - start) + " ms");

            synthesizer.waitForComplete(60000);
            logger.info("tts stop latency " + word + " " + (System.currentTimeMillis() - start) + " ms");

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (synthesizer != null) {
                synthesizer.close();
            }

        }
    }

    public SpeechSynthesizerListener process1(String word) {
        word = word.replaceAll("<.*?>", "");
        logger.info("word:" + word);
        com.alibaba.nls.client.protocol.tts.SpeechSynthesizer synthesizer = null;
        try {
            SpeechSynthesizerListener speechSynthesizerListener = getSynthesizerListener(new Date(), null);
            synthesizer = new com.alibaba.nls.client.protocol.tts.SpeechSynthesizer(AliTtsConfig.getNlsClient(), speechSynthesizerListener);
            synthesizer.setAppKey(aliTtsConfig.getAppKey());
            synthesizer.setFormat(OutputFormatEnum.WAV);
            synthesizer.setSampleRate(SampleRateEnum.SAMPLE_RATE_8K);
            synthesizer.setVoice(aliTtsConfig.getVoice());
            synthesizer.setVolume(aliTtsConfig.getVolume());
            synthesizer.setPitchRate(aliTtsConfig.getPitch_rate());
            synthesizer.setSpeechRate(aliTtsConfig.getPitch_rate());
            synthesizer.setText(word);
            synthesizer.addCustomedParam("enable_subtitle", true);

            long start = System.currentTimeMillis();
            synthesizer.start();
            logger.info("tts start latency " + word + " " + (System.currentTimeMillis() - start) + " ms");

            synthesizer.waitForComplete(60000);
            logger.info("tts stop latency " + word + " " + (System.currentTimeMillis() - start) + " ms");
            return speechSynthesizerListener;
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (synthesizer != null) {
                synthesizer.close();
            }

        }
        return null;
    }


}
