package com.ewaytek.deepseek.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson2.JSON;
import com.ewaytek.deepseek.common.bean.base.ApiResponse;
import com.ewaytek.deepseek.config.DeepSeekConfig;
import com.ewaytek.deepseek.config.DifyConfig;
import com.ewaytek.deepseek.doadmin.dto.*;
import com.ewaytek.deepseek.doadmin.vo.MessageVO;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyChatVO;
import com.ewaytek.deepseek.doadmin.vo.dify.DifyStreamVO;
import com.ewaytek.deepseek.service.AiChatService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class AiChatServiceA implements AiChatService {

    Map<String, Object> body = new HashMap<>();
    Headers headers;
    AiMessageDTO aiMessageDto;

    @Autowired
    private DeepSeekConfig deepSeekConfig;
    @Autowired
    private OkHttpClient httpClient;

    @Autowired
    private DifyConfig difyConfig;

    // 初始化
    @PostConstruct
    public void init() {
        body.put("model", deepSeekConfig.getModel());
        body.put("frequency_penalty", deepSeekConfig.getFrequencyPenalty());
        body.put("max_tokens", deepSeekConfig.getMaxTokens());
        body.put("presence_penalty", deepSeekConfig.getPresencePenalty());
        body.put("response_format", deepSeekConfig.getResponseFormat());
        body.put("stop", deepSeekConfig.getStop());

        body.put("stream", deepSeekConfig.getStream());
        if (deepSeekConfig.getStream()) {
            body.put("stream_options", deepSeekConfig.getStreamOptions());
        }

        body.put("temperature", deepSeekConfig.getTemperature());
        body.put("top_p", deepSeekConfig.getTopP());
        body.put("tools", deepSeekConfig.getTools());
        body.put("tool_choice", deepSeekConfig.getToolChoice());

        if (deepSeekConfig.getLogprobs()) {
            body.put("logprobs", deepSeekConfig.getLogprobs());
            body.put("top_logprobs", deepSeekConfig.getTopLogprobs());
        }

        // 构建请求头
        headers = new Headers.Builder().add("Authorization", "Bearer " + deepSeekConfig.getApiKey()).add("Content-Type", "application/json").build();

        if (deepSeekConfig.getStream()) {
            aiMessageDto = new StreamingAiMessageDTO();
        } else {
            aiMessageDto = new DefaultAiMessageDTO();
        }
    }


    @Override
    public Flux<String> chat(List<Map<String, String>> question) {
        body.put("messages", question);

        // 将请求体转换为 JSON 字符串
        ObjectMapper objectMapper = new ObjectMapper();
        String payload;
        try {
            payload = objectMapper.writeValueAsString(body);
        } catch (JsonProcessingException e) {
            throw new RuntimeException("无法将负载转换为JSON", e);
        }

        // 构建请求
        Request request = new Request.Builder().url(difyConfig.getApiHost()).post(RequestBody.create(payload, MediaType.parse("application/json"))).headers(headers).build();

        // 返回 Flux<String> 以流式返回数据
        return Flux.create(emitter -> {
            try (Response response = httpClient.newCall(request).execute()) {
                if (!response.isSuccessful()) {
                    emitter.error(new IOException("请求失败响应码: " + response.code()));
                    return;
                }
                // 处理流式响应
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    while (!responseBody.source().exhausted()) {
                        String line = responseBody.source().readUtf8Line();
                        if (line != null && !line.isEmpty()) {
                            try {
                                emitter.next(aiMessageDto.getMessage(line)); // 逐步发送数据
                            } catch (Exception e) {
                                log.error("处理数据时发生错误: ", e);
                            }
                        }
                    }
                    emitter.complete(); // 完成流
                }
            } catch (IOException e) {
                emitter.error(e);
                log.error(e.getMessage());
            }
        });
    }



    @Override
    public ApiResponse<MessageVO> msgChat(List<MessageDTO> messages) {
        MessageChatDTO messageChatDTO = new MessageChatDTO();
        messageChatDTO.setModel(deepSeekConfig.getModel());
        messageChatDTO.setMessages(messages);
        String json = JSON.toJSONString(messageChatDTO);
        log.info("msgChat" + json);
        HttpRequest request = HttpRequest.post(deepSeekConfig.getUrl())
                .header(Header.AUTHORIZATION, "Bearer " + deepSeekConfig.getApiKey())
                .header(Header.CONTENT_TYPE, "application/json")
                .body(json)
                .timeout(60000);
//        Request request = new Request.Builder()
//                .url(deepSeekConfig.getUrl())
//                .post(RequestBody.create(json, MediaType.parse("application/json")))
//                .headers(headers)
//                .build();
        // 执行请求并处理响应
        try (HttpResponse response = request.execute()) {
            if (response.isOk()) {
                String responseBody = response.body();
                log.info("Response: {}", responseBody);
                return ApiResponse.success(JSON.parseObject(responseBody, MessageVO.class));
            } else {
                log.error("Request failed with status code: {}", response.getStatus());
                return ApiResponse.fail("Request failed with status code: " + response.getStatus());
            }
        } catch (Exception e) {
            log.error("Error during request: ", e);
            return ApiResponse.fail("Error during request: " + e.getMessage());
        }
    }
}
